import numpy as np
import pandas as pd
from tqdm import trange
from Agent import Agent
import argparse

def parse():
    parser = argparse.ArgumentParser()
    parser.add_argument("-runs", type=int, default=100,
                        help='the number of macro replications')
    parser.add_argument("-n0", type=int, default=1,
                        help='the number of initial budget')
    parser.add_argument("-delta", type=float, default=0.1,
                        help='the threshold on probability of correct selection')
    parser.add_argument("-sampling_rule", type=str, default="DualSR",
                        help='EA, AFSR, AFOSR, SEQ_OFSR, DualSR') #EA:USR, AFSR:BCSR, AFOSR:GFSR, SEQ_OFSR: GOSR, DualSR: DSR
    args = parser.parse_args()
    return args

def simulate(runs, Agent):

    sample_complexity = np.zeros(runs)

    for r in trange(runs):
        Agent.reset()
        total_sample = 0
        while not Agent.stop():
            total_sample += 1
            next_context, next_design = Agent.sample()
            Agent.step(next_context, next_design)
        sample_complexity[r] = total_sample
    results = {"Complexity": sample_complexity}
    return results

def main(args):

    runs = args.runs
    n0 = args.n0
    delta = args.delta
    sampling_rule = args.sampling_rule

    Alg = Agent(n0, delta, sampling_rule)
    results = simulate(runs, Alg)
    pd.DataFrame(results).to_csv(f'Results/{sampling_rule}_n0_{n0}_sample_complexity.csv')

if __name__ == '__main__':
    args = parse()
    main(args)